---
title: IDM-VTON AI Model Usage Guide
slug: TaQ6XsKxYhbY62kmBLv72
createdAt: Thu Jul 18 2024 05:50:21 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:44:27 GMT+0000 (Coordinated Universal Time)
---

# IDM-VTON AI Model Usage Guide

## Introduction

This document describes how to use the aonet library to call the IDM-VTON AI model. This model is used for virtual try-on, allowing specified clothing images to be applied to human images.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Installation

Ensure that the aonet library is installed. If it is not installed yet, you can install it using npm:

```bash
npm install aonet
```

## Basic Usage

### 1. Import the AI Class

```js
const AI = require("aonet");
```

### 2. Configure Options

Create an options object containing authentication information:

```js
const options = {
    appId: "$APPID_KEY" // Replace with your APPID key
};
```

### 3. Initialize AI Instance

```js
const aonet = new AI(options);
```

### 4. Call the IDM-VTON Model

Use the `prediction` method to call the model:

```js
async function callIDMVTON() {
    try {
        let response = await aonet.prediction("/predictions/ai/idm-vton", {
            input: {
                "seed": 42,
                "steps": 30,
                "garm_img": "https://aonet.ai/pbxt/KgwTlZyFx5aUU3gc5gMiKuD5nNPTgliMlLUWx160G4z99YjO/sweater.webp",
                "human_img": "https://replicate.delivery/pbxt/KgwTlhCMvDagRrcVzZJbuozNJ8esPqiNAIJS3eMgHrYuHmW4/KakaoTalk_Photo_2024-04-04-21-44-45.png",
                "garment_des": "cute pink top"
            }
        });
        console.log("IDM-VTON Response:", response);
        return response;
    } catch (error) {
        console.error("Error calling IDM-VTON:", error);
        throw error;
    }
}
```

### Parameter Description

- `seed`: Random seed for generating reproducible results
- `steps`: Number of processing steps
- `garm_img`: URL of the garment image
- `human_img`: URL of the human image
- `garment_des`: Description of the garment

### Handling the Response

The model's response will contain the processed results. Depending on your application's needs, you may need to parse and use specific fields from the response.

### Error Handling

Use try-catch blocks to catch and handle possible errors.

## Best Practices

- **Store and Manage API Keys**: Do not hard-code API keys in your code. Use environment variables or secure key management systems.
- **Input Validation**: Validate all input parameters before sending requests.
- **Error Handling**: Implement comprehensive error handling, including network errors, API limits, and invalid responses.
- **Caching Strategy**: Consider implementing caching mechanisms to reduce duplicate requests and improve application performance.
- **Asynchronous Processing**: Use async/await or Promises to handle asynchronous operations, ensuring the main thread is not blocked.

### Notes

- Ensure you have enough API call quota.
- Ensure the validity and accessibility of image URLs.
- Adhere to the API provider's terms of use and restrictions.

## Example Code

```js
const AI = require("aonet");

async function runIDMVTON() {
    const options = {
        auth: process.env.AONET_API_KEY // Store API key in environment variable
    };
    const aonet = new AI(options);

    try {
        const response = await aonet.prediction("/predictions/ai/idm-vton", {
            input: {
                "seed": 42,
                "steps": 30,
                "garm_img": "https://example.com/garment.jpg",
                "human_img": "https://example.com/person.jpg",
                "garment_des": "elegant blue dress"
            }
        });
        console.log("IDM-VTON Result:", response);
        // Further processing of the response...
    } catch (error) {
        console.error("Error in IDM-VTON process:", error);
        // Error handling...
    }
}

runIDMVTON();
```

## Conclusion

By following this guide, you should be able to successfully integrate and use the IDM-VTON AI model for virtual try-on application development. If you encounter any issues or need further assistance, please refer to the official aonet documentation or contact technical support.
